// Lab03: Discretize the given  continuous-time system
//        using Bilinear Transformation.

//              scilab - 5.5.1
//              Operating System : Windows 7, 32-bit
//*****************************************************************************
//Clean the environment
close;
clear;
clc;

//****************************************************************************
// State space representation of continuous time system
//****************************************************************************
//
A=[0 1;-6 -5];
B=[0 1]';
C=[1 0];
D=0;
sysc=syslin('c',A,B,C,D);
//transfer function
Gs=ss2tf(sysc)
disp('Gs=')
disp(Gs)
//Response of the system
tc=0:0.1:10;
yc=csim("step",tc,sysc);

//****************************************************************************
// Discretization of the system using bilinear transformation at
// sampling time Ts=0.5 sec
//****************************************************************************
Ts=0.5;
sysd=cls2dls(sysc,Ts);
//Pulse transfer function
Gz=ss2tf(sysd)
disp('Gz=')
disp('Gz=',Gz)
//Response of the discrete system
td=0:Ts:10;
ud=ones(1,length(td));
yd=flts(ud,sysd);

//****************************************************************************
// Ploting the responses
//****************************************************************************
plot2d(tc,yc,5)//continuous time
plot2d2(td,yd,2) // Discrete time
xgrid(35)
title('Responses of continous and Tustin transformed discrete time system','fontsize',3)
xlabel('kT','fontsize',2)
ylabel('y(kT)','fontsize',2)
h=legend('y(t)', 'y(kT)')
h.legend_location = "in_lower_right";
